/* Antarmuka dengan Sensor Sidik Jari - Trainer Internet of Things
 * Project : Daftar sidik jari
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library Sidik Jari
#include <Adafruit_Fingerprint.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
// Library Software Serial
#include <SoftwareSerial.h>

// PIN Buzzer terhubung ke PIN D3 NodeMCU
#define BUZZ_PIN  D3

// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);

// Koneksi PIN Fingerprint ke PIN NodeMCU
// TX   D5
// RX   D6
// SofwareSerial objek dengan nama FP_Serial
SoftwareSerial FP_Serial(D5, D6);

// Fingerprint Objek dengan nama finger
// dengan koneksi serial FP_Serial
Adafruit_Fingerprint finger = Adafruit_Fingerprint(&FP_Serial);
// Variabel untuk menyimpan ID
int id;

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  // Mengatur BUZZ_PIN sebagai Output
  // Kondisi awal BUZZ_PIN LOW (Buzzer OFF)
  pinMode(BUZZ_PIN, OUTPUT);
  digitalWrite(BUZZ_PIN, LOW);

  // Komunikasi Serial FP dengan baudrate 57600
  finger.begin(57600);
  
  lcd.init();       // Inisialisasi LCD
  lcd.backlight();  // Menyalakan Backlight LCD
  lcd.print("Trainer Kit IoT"); 
  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD

  // Cek koneksi fingerprint
  if(finger.verifyPassword()) {
    lcd.setCursor(0,0); lcd.print("Sensor ditemukan");
    Serial.println("Sensor ditemukan");
    delay(1000);
    lcd.clear();
  }else{
    lcd.setCursor(0,0); lcd.print("Tidak Ada Sensor");
    Serial.println("Tidak Ada Sensor");
    delay(1000);
    lcd.clear();
  }
}

// Membaca angka (ID) dari serial monitor
int baca_id() {
  uint8_t num = 0;
  while (num == 0) {
    while (!Serial.available());
    num = Serial.parseInt();
  }
  buzz_done();
  return num;
}

void loop() {
  // Mencetak teks ke serial monitor dan LCD 16x2 I2C
  Serial.println("Ketik ID (1-127) yang akan didaftarkan!");
  lcd.setCursor(0,0); lcd.print("Ketik ID (1-127)");
  lcd.setCursor(0,1); lcd.print(" Serial Monitor ");

  // Memabaca ID
  id = baca_id();
  if (id == 0) {
     return;
  }
  Serial.print("Mendaftar ID#");
  Serial.println(id);

  while(!getFingerprintEnroll());
}

// Fungsi pendaftaran sidik jari
uint8_t getFingerprintEnroll() {
  int p = -1;
  // Memindai Sidik jari (1)
  lcd.setCursor(0,0); lcd.print("Tempel jari anda");
  lcd.setCursor(0,1); lcd.print("................");
  while(p != FINGERPRINT_OK) {
     p = finger.getImage();
     if(p == FINGERPRINT_OK){
      buzz_notif();
      lcd.setCursor(0,0); lcd.print("Scanning sensor ");
      lcd.setCursor(0,1); lcd.print("................");
      delay(2000);
      Serial.println("Memindai sidik jari (1)");
      break;
     }
  }

  // Konversi sidik jari (1)
  p = finger.image2Tz(1);
  if(p == FINGERPRINT_OK){
    Serial.println("Konversi sidik jari (1)");
  }else{
    return p;
  }

  Serial.println("Lepas jari");
  buzz_done();
  lcd.setCursor(0,0); lcd.print("Lepas jari      ");
  lcd.setCursor(0,1); lcd.print("................");
  p = 0;
  while (p != FINGERPRINT_NOFINGER) {
    p = finger.getImage();
  }

  // Memindai sidik jari (2)
  p = -1;
  Serial.println("Letakkan lagi jari yang sama");
  lcd.setCursor(0,0); lcd.print("Letakkan kembali");
  lcd.setCursor(0,1); lcd.print("................");
  while (p != FINGERPRINT_OK) {
    p = finger.getImage();
    if(p == FINGERPRINT_OK){
      buzz_notif();
      Serial.println("Memindai sidik jari (2)");
      break;
    }
  }

  // Konversi sidik jari (2)
  p = finger.image2Tz(2);
  if(p == FINGERPRINT_OK){
    Serial.println("Konversi sidik jari (2)");
  }else{
    return p;
  }

  // Pencocokan sidik jari
  p = finger.createModel();
  if (p == FINGERPRINT_OK) {
    Serial.println("Sidik jari cocok");
    buzz_match();
    lcd.setCursor(0,0); lcd.print("Sidik jari cocok");
    lcd.setCursor(0,1); lcd.print("................");
    delay(2000);
  }else if (p == FINGERPRINT_ENROLLMISMATCH){
    Serial.println("Sidik jari tidak cocok");
    buzz_not_match();
    lcd.setCursor(0,0); lcd.print("Tidak cocok     ");
    lcd.setCursor(0,1); lcd.print("Ulangi proses   ");
    delay(2000);
    return p;
  }

  // Menyimpan data sidik jari
  p = finger.storeModel(id);
  if (p == FINGERPRINT_OK) {
    Serial.println("Sidik jari disimpan!");
    buzz_store_id();
    lcd.setCursor(0,0); lcd.print("Menyimpan data..");
    lcd.setCursor(0,1); lcd.print("ID " + String(id) + " Tersimpan  ");
    delay(3000);
  }else{
    Serial.println("Sidik jari disimpan!");
    buzz_not_match();
    lcd.setCursor(0,0); lcd.print("Gagal Menyimpan ");
    lcd.setCursor(0,1); lcd.print("Ulangi proses   ");
    delay(3000);
    return p;
  }

  return true;
}

// Fungsi Nada Buzzer scan sidik jari
void buzz_notif() {
  for (int x = 0; x < 8 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(50);
    digitalWrite(BUZZ_PIN, LOW);
    delay(30);
    }
}

// Fungsi Nada Buzzer notifikasi
void buzz_done(){
  digitalWrite(BUZZ_PIN, HIGH);
  delay(200);
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}

// Fungsi Nada Buzzer sidik jari cocok
void buzz_match() {
  for (int x = 0; x < 2 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(200);
    digitalWrite(BUZZ_PIN, LOW);
    delay(100);
  }
}

// Fungsi Nada Buzzer sidik jari tidak cocok
void buzz_not_match() {
  digitalWrite(BUZZ_PIN, HIGH);
  delay(1000);
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}

// Fungsi Nada Buzzer menyimpan ID sidik jari
void buzz_store_id(){
  for (int x = 0; x < 2 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(200);
    digitalWrite(BUZZ_PIN, LOW);
    delay(100);
  }
  digitalWrite(BUZZ_PIN, HIGH);
  delay(500);
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}
